//------------------------------------------------------------------------------
// Lab. 01: Obtain state model of the second order system cascaded with active 
// lead circuit. Show its step response.
//------------------------------------------------------------------------------

//scilab-5.5.0
//Operating System : OS X 10.9.3

//Clean the environment
clc;
clear all;
clf;

// Compensator model
R1=1000; R2=5e3;C1=1e-6;C2=1e-5;
kc=5;
s=poly(0,'s');
g=kc*(R1*C1*s+1)/(R2*C2*s+1);

// System transfer function
g1=0.2/(s^2+1.7*s+1);

// Overall transfer function
sys=tf2ss(g*g1);

// Unit step response
t=linspace(0,10,1000);
y=csim('step',t,sys);
plot(t,y);
title('Unit step response of the electrical system','fontsize',4)
xlabel('Time t','fontsize',2)
ylabel('Response y(t)','fontsize',2)
//set(gca(),"grid",[0.3 0.3])

